<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\GooglePayExperienceContext;

/**
 * Builder for model GooglePayExperienceContext
 *
 * @see GooglePayExperienceContext
 */
class GooglePayExperienceContextBuilder
{
    /**
     * @var GooglePayExperienceContext
     */
    private $instance;

    private function __construct(GooglePayExperienceContext $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Google Pay Experience Context Builder object.
     *
     * @param string $returnUrl
     * @param string $cancelUrl
     */
    public static function init(string $returnUrl, string $cancelUrl): self
    {
        return new self(new GooglePayExperienceContext($returnUrl, $cancelUrl));
    }

    /**
     * Initializes a new Google Pay Experience Context object.
     */
    public function build(): GooglePayExperienceContext
    {
        return CoreHelper::clone($this->instance);
    }
}
