<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ModifySubscriptionRequest;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\PlanOverride;
use PaypalServerSdkLib\Models\ShippingDetails;
use PaypalServerSdkLib\Models\SubscriptionPatchApplicationContext;

/**
 * Builder for model ModifySubscriptionRequest
 *
 * @see ModifySubscriptionRequest
 */
class ModifySubscriptionRequestBuilder
{
    /**
     * @var ModifySubscriptionRequest
     */
    private $instance;

    private function __construct(ModifySubscriptionRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Modify Subscription Request Builder object.
     */
    public static function init(): self
    {
        return new self(new ModifySubscriptionRequest());
    }

    /**
     * Sets plan id field.
     *
     * @param string|null $value
     */
    public function planId(?string $value): self
    {
        $this->instance->setPlanId($value);
        return $this;
    }

    /**
     * Sets quantity field.
     *
     * @param string|null $value
     */
    public function quantity(?string $value): self
    {
        $this->instance->setQuantity($value);
        return $this;
    }

    /**
     * Sets shipping amount field.
     *
     * @param Money|null $value
     */
    public function shippingAmount(?Money $value): self
    {
        $this->instance->setShippingAmount($value);
        return $this;
    }

    /**
     * Sets shipping address field.
     *
     * @param ShippingDetails|null $value
     */
    public function shippingAddress(?ShippingDetails $value): self
    {
        $this->instance->setShippingAddress($value);
        return $this;
    }

    /**
     * Sets application context field.
     *
     * @param SubscriptionPatchApplicationContext|null $value
     */
    public function applicationContext(?SubscriptionPatchApplicationContext $value): self
    {
        $this->instance->setApplicationContext($value);
        return $this;
    }

    /**
     * Sets plan field.
     *
     * @param PlanOverride|null $value
     */
    public function plan(?PlanOverride $value): self
    {
        $this->instance->setPlan($value);
        return $this;
    }

    /**
     * Initializes a new Modify Subscription Request object.
     */
    public function build(): ModifySubscriptionRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
