<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\NativeAppContext;

/**
 * Builder for model NativeAppContext
 *
 * @see NativeAppContext
 */
class NativeAppContextBuilder
{
    /**
     * @var NativeAppContext
     */
    private $instance;

    private function __construct(NativeAppContext $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Native App Context Builder object.
     */
    public static function init(): self
    {
        return new self(new NativeAppContext());
    }

    /**
     * Sets os type field.
     *
     * @param string|null $value
     */
    public function osType(?string $value): self
    {
        $this->instance->setOsType($value);
        return $this;
    }

    /**
     * Sets os version field.
     *
     * @param string|null $value
     */
    public function osVersion(?string $value): self
    {
        $this->instance->setOsVersion($value);
        return $this;
    }

    /**
     * Initializes a new Native App Context object.
     */
    public function build(): NativeAppContext
    {
        return CoreHelper::clone($this->instance);
    }
}
