<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\OrderAuthorizeRequest;
use PaypalServerSdkLib\Models\OrderAuthorizeRequestPaymentSource;

/**
 * Builder for model OrderAuthorizeRequest
 *
 * @see OrderAuthorizeRequest
 */
class OrderAuthorizeRequestBuilder
{
    /**
     * @var OrderAuthorizeRequest
     */
    private $instance;

    private function __construct(OrderAuthorizeRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Order Authorize Request Builder object.
     */
    public static function init(): self
    {
        return new self(new OrderAuthorizeRequest());
    }

    /**
     * Sets payment source field.
     *
     * @param OrderAuthorizeRequestPaymentSource|null $value
     */
    public function paymentSource(?OrderAuthorizeRequestPaymentSource $value): self
    {
        $this->instance->setPaymentSource($value);
        return $this;
    }

    /**
     * Initializes a new Order Authorize Request object.
     */
    public function build(): OrderAuthorizeRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
