<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\Name;
use PaypalServerSdkLib\Models\Payer;
use PaypalServerSdkLib\Models\PhoneWithType;
use PaypalServerSdkLib\Models\TaxInfo;

/**
 * Builder for model Payer
 *
 * @see Payer
 */
class PayerBuilder
{
    /**
     * @var Payer
     */
    private $instance;

    private function __construct(Payer $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Payer Builder object.
     */
    public static function init(): self
    {
        return new self(new Payer());
    }

    /**
     * Sets email address field.
     *
     * @param string|null $value
     */
    public function emailAddress(?string $value): self
    {
        $this->instance->setEmailAddress($value);
        return $this;
    }

    /**
     * Sets payer id field.
     *
     * @param string|null $value
     */
    public function payerId(?string $value): self
    {
        $this->instance->setPayerId($value);
        return $this;
    }

    /**
     * Sets name field.
     *
     * @param Name|null $value
     */
    public function name(?Name $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets phone field.
     *
     * @param PhoneWithType|null $value
     */
    public function phone(?PhoneWithType $value): self
    {
        $this->instance->setPhone($value);
        return $this;
    }

    /**
     * Sets birth date field.
     *
     * @param string|null $value
     */
    public function birthDate(?string $value): self
    {
        $this->instance->setBirthDate($value);
        return $this;
    }

    /**
     * Sets tax info field.
     *
     * @param TaxInfo|null $value
     */
    public function taxInfo(?TaxInfo $value): self
    {
        $this->instance->setTaxInfo($value);
        return $this;
    }

    /**
     * Sets address field.
     *
     * @param Address|null $value
     */
    public function address(?Address $value): self
    {
        $this->instance->setAddress($value);
        return $this;
    }

    /**
     * Initializes a new Payer object.
     */
    public function build(): Payer
    {
        return CoreHelper::clone($this->instance);
    }
}
