<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PayerInformation;
use PaypalServerSdkLib\Models\PayerName;
use PaypalServerSdkLib\Models\Phone;
use PaypalServerSdkLib\Models\SimplePostalAddressCoarseGrained;

/**
 * Builder for model PayerInformation
 *
 * @see PayerInformation
 */
class PayerInformationBuilder
{
    /**
     * @var PayerInformation
     */
    private $instance;

    private function __construct(PayerInformation $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Payer Information Builder object.
     */
    public static function init(): self
    {
        return new self(new PayerInformation());
    }

    /**
     * Sets account id field.
     *
     * @param string|null $value
     */
    public function accountId(?string $value): self
    {
        $this->instance->setAccountId($value);
        return $this;
    }

    /**
     * Sets email address field.
     *
     * @param string|null $value
     */
    public function emailAddress(?string $value): self
    {
        $this->instance->setEmailAddress($value);
        return $this;
    }

    /**
     * Sets phone number field.
     *
     * @param Phone|null $value
     */
    public function phoneNumber(?Phone $value): self
    {
        $this->instance->setPhoneNumber($value);
        return $this;
    }

    /**
     * Sets address status field.
     *
     * @param string|null $value
     */
    public function addressStatus(?string $value): self
    {
        $this->instance->setAddressStatus($value);
        return $this;
    }

    /**
     * Sets payer status field.
     *
     * @param string|null $value
     */
    public function payerStatus(?string $value): self
    {
        $this->instance->setPayerStatus($value);
        return $this;
    }

    /**
     * Sets payer name field.
     *
     * @param PayerName|null $value
     */
    public function payerName(?PayerName $value): self
    {
        $this->instance->setPayerName($value);
        return $this;
    }

    /**
     * Sets country code field.
     *
     * @param string|null $value
     */
    public function countryCode(?string $value): self
    {
        $this->instance->setCountryCode($value);
        return $this;
    }

    /**
     * Sets address field.
     *
     * @param SimplePostalAddressCoarseGrained|null $value
     */
    public function address(?SimplePostalAddressCoarseGrained $value): self
    {
        $this->instance->setAddress($value);
        return $this;
    }

    /**
     * Initializes a new Payer Information object.
     */
    public function build(): PayerInformation
    {
        return CoreHelper::clone($this->instance);
    }
}
