<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\AuthorizationWithAdditionalData;
use PaypalServerSdkLib\Models\OrdersCapture;
use PaypalServerSdkLib\Models\PaymentCollection;
use PaypalServerSdkLib\Models\Refund;

/**
 * Builder for model PaymentCollection
 *
 * @see PaymentCollection
 */
class PaymentCollectionBuilder
{
    /**
     * @var PaymentCollection
     */
    private $instance;

    private function __construct(PaymentCollection $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Payment Collection Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentCollection());
    }

    /**
     * Sets authorizations field.
     *
     * @param AuthorizationWithAdditionalData[]|null $value
     */
    public function authorizations(?array $value): self
    {
        $this->instance->setAuthorizations($value);
        return $this;
    }

    /**
     * Sets captures field.
     *
     * @param OrdersCapture[]|null $value
     */
    public function captures(?array $value): self
    {
        $this->instance->setCaptures($value);
        return $this;
    }

    /**
     * Sets refunds field.
     *
     * @param Refund[]|null $value
     */
    public function refunds(?array $value): self
    {
        $this->instance->setRefunds($value);
        return $this;
    }

    /**
     * Initializes a new Payment Collection object.
     */
    public function build(): PaymentCollection
    {
        return CoreHelper::clone($this->instance);
    }
}
