<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\PaymentPreferences;

/**
 * Builder for model PaymentPreferences
 *
 * @see PaymentPreferences
 */
class PaymentPreferencesBuilder
{
    /**
     * @var PaymentPreferences
     */
    private $instance;

    private function __construct(PaymentPreferences $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Payment Preferences Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentPreferences());
    }

    /**
     * Sets auto bill outstanding field.
     *
     * @param bool|null $value
     */
    public function autoBillOutstanding(?bool $value): self
    {
        $this->instance->setAutoBillOutstanding($value);
        return $this;
    }

    /**
     * Sets setup fee field.
     *
     * @param Money|null $value
     */
    public function setupFee(?Money $value): self
    {
        $this->instance->setSetupFee($value);
        return $this;
    }

    /**
     * Sets setup fee failure action field.
     *
     * @param string|null $value
     */
    public function setupFeeFailureAction(?string $value): self
    {
        $this->instance->setSetupFeeFailureAction($value);
        return $this;
    }

    /**
     * Sets payment failure threshold field.
     *
     * @param int|null $value
     */
    public function paymentFailureThreshold(?int $value): self
    {
        $this->instance->setPaymentFailureThreshold($value);
        return $this;
    }

    /**
     * Initializes a new Payment Preferences object.
     */
    public function build(): PaymentPreferences
    {
        return CoreHelper::clone($this->instance);
    }
}
