<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PaymentTokenRequestCard;
use PaypalServerSdkLib\Models\PaymentTokenRequestPaymentSource;
use PaypalServerSdkLib\Models\VaultTokenRequest;

/**
 * Builder for model PaymentTokenRequestPaymentSource
 *
 * @see PaymentTokenRequestPaymentSource
 */
class PaymentTokenRequestPaymentSourceBuilder
{
    /**
     * @var PaymentTokenRequestPaymentSource
     */
    private $instance;

    private function __construct(PaymentTokenRequestPaymentSource $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Payment Token Request Payment Source Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentTokenRequestPaymentSource());
    }

    /**
     * Sets card field.
     *
     * @param PaymentTokenRequestCard|null $value
     */
    public function card(?PaymentTokenRequestCard $value): self
    {
        $this->instance->setCard($value);
        return $this;
    }

    /**
     * Sets token field.
     *
     * @param VaultTokenRequest|null $value
     */
    public function token(?VaultTokenRequest $value): self
    {
        $this->instance->setToken($value);
        return $this;
    }

    /**
     * Initializes a new Payment Token Request Payment Source object.
     */
    public function build(): PaymentTokenRequestPaymentSource
    {
        return CoreHelper::clone($this->instance);
    }
}
