<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CaptureStatusDetails;
use PaypalServerSdkLib\Models\LinkDescription;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\NetworkTransaction;
use PaypalServerSdkLib\Models\PaymentsCapture;
use PaypalServerSdkLib\Models\ProcessorResponse;
use PaypalServerSdkLib\Models\SellerProtection;
use PaypalServerSdkLib\Models\SellerReceivableBreakdown;

/**
 * Builder for model PaymentsCapture
 *
 * @see PaymentsCapture
 */
class PaymentsCaptureBuilder
{
    /**
     * @var PaymentsCapture
     */
    private $instance;

    private function __construct(PaymentsCapture $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Payments Capture Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentsCapture());
    }

    /**
     * Sets status field.
     *
     * @param string|null $value
     */
    public function status(?string $value): self
    {
        $this->instance->setStatus($value);
        return $this;
    }

    /**
     * Sets status details field.
     *
     * @param CaptureStatusDetails|null $value
     */
    public function statusDetails(?CaptureStatusDetails $value): self
    {
        $this->instance->setStatusDetails($value);
        return $this;
    }

    /**
     * Sets id field.
     *
     * @param string|null $value
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets amount field.
     *
     * @param Money|null $value
     */
    public function amount(?Money $value): self
    {
        $this->instance->setAmount($value);
        return $this;
    }

    /**
     * Sets invoice id field.
     *
     * @param string|null $value
     */
    public function invoiceId(?string $value): self
    {
        $this->instance->setInvoiceId($value);
        return $this;
    }

    /**
     * Sets custom id field.
     *
     * @param string|null $value
     */
    public function customId(?string $value): self
    {
        $this->instance->setCustomId($value);
        return $this;
    }

    /**
     * Sets network transaction reference field.
     *
     * @param NetworkTransaction|null $value
     */
    public function networkTransactionReference(?NetworkTransaction $value): self
    {
        $this->instance->setNetworkTransactionReference($value);
        return $this;
    }

    /**
     * Sets seller protection field.
     *
     * @param SellerProtection|null $value
     */
    public function sellerProtection(?SellerProtection $value): self
    {
        $this->instance->setSellerProtection($value);
        return $this;
    }

    /**
     * Sets final capture field.
     *
     * @param bool|null $value
     */
    public function finalCapture(?bool $value): self
    {
        $this->instance->setFinalCapture($value);
        return $this;
    }

    /**
     * Sets seller receivable breakdown field.
     *
     * @param SellerReceivableBreakdown|null $value
     */
    public function sellerReceivableBreakdown(?SellerReceivableBreakdown $value): self
    {
        $this->instance->setSellerReceivableBreakdown($value);
        return $this;
    }

    /**
     * Sets disbursement mode field.
     *
     * @param string|null $value
     */
    public function disbursementMode(?string $value): self
    {
        $this->instance->setDisbursementMode($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param LinkDescription[]|null $value
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Sets processor response field.
     *
     * @param ProcessorResponse|null $value
     */
    public function processorResponse(?ProcessorResponse $value): self
    {
        $this->instance->setProcessorResponse($value);
        return $this;
    }

    /**
     * Sets create time field.
     *
     * @param string|null $value
     */
    public function createTime(?string $value): self
    {
        $this->instance->setCreateTime($value);
        return $this;
    }

    /**
     * Sets update time field.
     *
     * @param string|null $value
     */
    public function updateTime(?string $value): self
    {
        $this->instance->setUpdateTime($value);
        return $this;
    }

    /**
     * Initializes a new Payments Capture object.
     */
    public function build(): PaymentsCapture
    {
        return CoreHelper::clone($this->instance);
    }
}
