<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PhoneNumberWithOptionalCountryCode;

/**
 * Builder for model PhoneNumberWithOptionalCountryCode
 *
 * @see PhoneNumberWithOptionalCountryCode
 */
class PhoneNumberWithOptionalCountryCodeBuilder
{
    /**
     * @var PhoneNumberWithOptionalCountryCode
     */
    private $instance;

    private function __construct(PhoneNumberWithOptionalCountryCode $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Phone Number With Optional Country Code Builder object.
     *
     * @param string $nationalNumber
     */
    public static function init(string $nationalNumber): self
    {
        return new self(new PhoneNumberWithOptionalCountryCode($nationalNumber));
    }

    /**
     * Sets country code field.
     *
     * @param string|null $value
     */
    public function countryCode(?string $value): self
    {
        $this->instance->setCountryCode($value);
        return $this;
    }

    /**
     * Initializes a new Phone Number With Optional Country Code object.
     */
    public function build(): PhoneNumberWithOptionalCountryCode
    {
        return CoreHelper::clone($this->instance);
    }
}
