<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\BillingCycleOverride;
use PaypalServerSdkLib\Models\PaymentPreferencesOverride;
use PaypalServerSdkLib\Models\PlanOverride;
use PaypalServerSdkLib\Models\TaxesOverride;

/**
 * Builder for model PlanOverride
 *
 * @see PlanOverride
 */
class PlanOverrideBuilder
{
    /**
     * @var PlanOverride
     */
    private $instance;

    private function __construct(PlanOverride $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Plan Override Builder object.
     */
    public static function init(): self
    {
        return new self(new PlanOverride());
    }

    /**
     * Sets billing cycles field.
     *
     * @param BillingCycleOverride[]|null $value
     */
    public function billingCycles(?array $value): self
    {
        $this->instance->setBillingCycles($value);
        return $this;
    }

    /**
     * Sets payment preferences field.
     *
     * @param PaymentPreferencesOverride|null $value
     */
    public function paymentPreferences(?PaymentPreferencesOverride $value): self
    {
        $this->instance->setPaymentPreferences($value);
        return $this;
    }

    /**
     * Sets taxes field.
     *
     * @param TaxesOverride|null $value
     */
    public function taxes(?TaxesOverride $value): self
    {
        $this->instance->setTaxes($value);
        return $this;
    }

    /**
     * Initializes a new Plan Override object.
     */
    public function build(): PlanOverride
    {
        return CoreHelper::clone($this->instance);
    }
}
