<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\RefundPlatformFee;

/**
 * Builder for model RefundPlatformFee
 *
 * @see RefundPlatformFee
 */
class RefundPlatformFeeBuilder
{
    /**
     * @var RefundPlatformFee
     */
    private $instance;

    private function __construct(RefundPlatformFee $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Refund Platform Fee Builder object.
     *
     * @param Money $amount
     */
    public static function init(Money $amount): self
    {
        return new self(new RefundPlatformFee($amount));
    }

    /**
     * Initializes a new Refund Platform Fee object.
     */
    public function build(): RefundPlatformFee
    {
        return CoreHelper::clone($this->instance);
    }
}
