<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Customer;
use PaypalServerSdkLib\Models\SetupTokenRequest;
use PaypalServerSdkLib\Models\SetupTokenRequestPaymentSource;

/**
 * Builder for model SetupTokenRequest
 *
 * @see SetupTokenRequest
 */
class SetupTokenRequestBuilder
{
    /**
     * @var SetupTokenRequest
     */
    private $instance;

    private function __construct(SetupTokenRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Setup Token Request Builder object.
     *
     * @param SetupTokenRequestPaymentSource $paymentSource
     */
    public static function init(SetupTokenRequestPaymentSource $paymentSource): self
    {
        return new self(new SetupTokenRequest($paymentSource));
    }

    /**
     * Sets customer field.
     *
     * @param Customer|null $value
     */
    public function customer(?Customer $value): self
    {
        $this->instance->setCustomer($value);
        return $this;
    }

    /**
     * Initializes a new Setup Token Request object.
     */
    public function build(): SetupTokenRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
