<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\ShippingOption;

/**
 * Builder for model ShippingOption
 *
 * @see ShippingOption
 */
class ShippingOptionBuilder
{
    /**
     * @var ShippingOption
     */
    private $instance;

    private function __construct(ShippingOption $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Shipping Option Builder object.
     *
     * @param string $id
     * @param string $label
     * @param bool $selected
     */
    public static function init(string $id, string $label, bool $selected): self
    {
        return new self(new ShippingOption($id, $label, $selected));
    }

    /**
     * Sets type field.
     *
     * @param string|null $value
     */
    public function type(?string $value): self
    {
        $this->instance->setType($value);
        return $this;
    }

    /**
     * Sets amount field.
     *
     * @param Money|null $value
     */
    public function amount(?Money $value): self
    {
        $this->instance->setAmount($value);
        return $this;
    }

    /**
     * Initializes a new Shipping Option object.
     */
    public function build(): ShippingOption
    {
        return CoreHelper::clone($this->instance);
    }
}
