<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\SimplePostalAddressCoarseGrained;

/**
 * Builder for model SimplePostalAddressCoarseGrained
 *
 * @see SimplePostalAddressCoarseGrained
 */
class SimplePostalAddressCoarseGrainedBuilder
{
    /**
     * @var SimplePostalAddressCoarseGrained
     */
    private $instance;

    private function __construct(SimplePostalAddressCoarseGrained $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Simple Postal Address Coarse Grained Builder object.
     *
     * @param string $line1
     * @param string $city
     * @param string $countryCode
     */
    public static function init(string $line1, string $city, string $countryCode): self
    {
        return new self(new SimplePostalAddressCoarseGrained($line1, $city, $countryCode));
    }

    /**
     * Sets line 2 field.
     *
     * @param string|null $value
     */
    public function line2(?string $value): self
    {
        $this->instance->setLine2($value);
        return $this;
    }

    /**
     * Sets state field.
     *
     * @param string|null $value
     */
    public function state(?string $value): self
    {
        $this->instance->setState($value);
        return $this;
    }

    /**
     * Sets postal code field.
     *
     * @param string|null $value
     */
    public function postalCode(?string $value): self
    {
        $this->instance->setPostalCode($value);
        return $this;
    }

    /**
     * Initializes a new Simple Postal Address Coarse Grained object.
     */
    public function build(): SimplePostalAddressCoarseGrained
    {
        return CoreHelper::clone($this->instance);
    }
}
