<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\StoreInformation;

/**
 * Builder for model StoreInformation
 *
 * @see StoreInformation
 */
class StoreInformationBuilder
{
    /**
     * @var StoreInformation
     */
    private $instance;

    private function __construct(StoreInformation $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Store Information Builder object.
     */
    public static function init(): self
    {
        return new self(new StoreInformation());
    }

    /**
     * Sets store id field.
     *
     * @param string|null $value
     */
    public function storeId(?string $value): self
    {
        $this->instance->setStoreId($value);
        return $this;
    }

    /**
     * Sets terminal id field.
     *
     * @param string|null $value
     */
    public function terminalId(?string $value): self
    {
        $this->instance->setTerminalId($value);
        return $this;
    }

    /**
     * Initializes a new Store Information object.
     */
    public function build(): StoreInformation
    {
        return CoreHelper::clone($this->instance);
    }
}
