<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Name;
use PaypalServerSdkLib\Models\ShippingDetails;
use PaypalServerSdkLib\Models\Subscriber;
use PaypalServerSdkLib\Models\SubscriptionPaymentSourceResponse;

/**
 * Builder for model Subscriber
 *
 * @see Subscriber
 */
class SubscriberBuilder
{
    /**
     * @var Subscriber
     */
    private $instance;

    private function __construct(Subscriber $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscriber Builder object.
     */
    public static function init(): self
    {
        return new self(new Subscriber());
    }

    /**
     * Sets name field.
     *
     * @param Name|null $value
     */
    public function name(?Name $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets shipping address field.
     *
     * @param ShippingDetails|null $value
     */
    public function shippingAddress(?ShippingDetails $value): self
    {
        $this->instance->setShippingAddress($value);
        return $this;
    }

    /**
     * Sets payment source field.
     *
     * @param SubscriptionPaymentSourceResponse|null $value
     */
    public function paymentSource(?SubscriptionPaymentSourceResponse $value): self
    {
        $this->instance->setPaymentSource($value);
        return $this;
    }

    /**
     * Initializes a new Subscriber object.
     */
    public function build(): Subscriber
    {
        return CoreHelper::clone($this->instance);
    }
}
