<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CycleExecution;
use PaypalServerSdkLib\Models\FailedPaymentDetails;
use PaypalServerSdkLib\Models\LastPaymentDetails;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\SubscriptionBillingInformation;

/**
 * Builder for model SubscriptionBillingInformation
 *
 * @see SubscriptionBillingInformation
 */
class SubscriptionBillingInformationBuilder
{
    /**
     * @var SubscriptionBillingInformation
     */
    private $instance;

    private function __construct(SubscriptionBillingInformation $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscription Billing Information Builder object.
     *
     * @param Money $outstandingBalance
     * @param int $failedPaymentsCount
     */
    public static function init(Money $outstandingBalance, int $failedPaymentsCount): self
    {
        return new self(new SubscriptionBillingInformation($outstandingBalance, $failedPaymentsCount));
    }

    /**
     * Sets cycle executions field.
     *
     * @param CycleExecution[]|null $value
     */
    public function cycleExecutions(?array $value): self
    {
        $this->instance->setCycleExecutions($value);
        return $this;
    }

    /**
     * Sets last payment field.
     *
     * @param LastPaymentDetails|null $value
     */
    public function lastPayment(?LastPaymentDetails $value): self
    {
        $this->instance->setLastPayment($value);
        return $this;
    }

    /**
     * Sets next billing time field.
     *
     * @param string|null $value
     */
    public function nextBillingTime(?string $value): self
    {
        $this->instance->setNextBillingTime($value);
        return $this;
    }

    /**
     * Sets final payment time field.
     *
     * @param string|null $value
     */
    public function finalPaymentTime(?string $value): self
    {
        $this->instance->setFinalPaymentTime($value);
        return $this;
    }

    /**
     * Sets last failed payment field.
     *
     * @param FailedPaymentDetails|null $value
     */
    public function lastFailedPayment(?FailedPaymentDetails $value): self
    {
        $this->instance->setLastFailedPayment($value);
        return $this;
    }

    /**
     * Initializes a new Subscription Billing Information object.
     */
    public function build(): SubscriptionBillingInformation
    {
        return CoreHelper::clone($this->instance);
    }
}
