<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PaymentMethod;
use PaypalServerSdkLib\Models\SubscriptionPatchApplicationContext;

/**
 * Builder for model SubscriptionPatchApplicationContext
 *
 * @see SubscriptionPatchApplicationContext
 */
class SubscriptionPatchApplicationContextBuilder
{
    /**
     * @var SubscriptionPatchApplicationContext
     */
    private $instance;

    private function __construct(SubscriptionPatchApplicationContext $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscription Patch Application Context Builder object.
     *
     * @param string $returnUrl
     * @param string $cancelUrl
     */
    public static function init(string $returnUrl, string $cancelUrl): self
    {
        return new self(new SubscriptionPatchApplicationContext($returnUrl, $cancelUrl));
    }

    /**
     * Sets brand name field.
     *
     * @param string|null $value
     */
    public function brandName(?string $value): self
    {
        $this->instance->setBrandName($value);
        return $this;
    }

    /**
     * Sets locale field.
     *
     * @param string|null $value
     */
    public function locale(?string $value): self
    {
        $this->instance->setLocale($value);
        return $this;
    }

    /**
     * Sets shipping preference field.
     *
     * @param string|null $value
     */
    public function shippingPreference(?string $value): self
    {
        $this->instance->setShippingPreference($value);
        return $this;
    }

    /**
     * Sets payment method field.
     *
     * @param PaymentMethod|null $value
     */
    public function paymentMethod(?PaymentMethod $value): self
    {
        $this->instance->setPaymentMethod($value);
        return $this;
    }

    /**
     * Initializes a new Subscription Patch Application Context object.
     */
    public function build(): SubscriptionPatchApplicationContext
    {
        return CoreHelper::clone($this->instance);
    }
}
