<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\SubscriptionPayerName;

/**
 * Builder for model SubscriptionPayerName
 *
 * @see SubscriptionPayerName
 */
class SubscriptionPayerNameBuilder
{
    /**
     * @var SubscriptionPayerName
     */
    private $instance;

    private function __construct(SubscriptionPayerName $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscription Payer Name Builder object.
     */
    public static function init(): self
    {
        return new self(new SubscriptionPayerName());
    }

    /**
     * Sets prefix field.
     *
     * @param string|null $value
     */
    public function prefix(?string $value): self
    {
        $this->instance->setPrefix($value);
        return $this;
    }

    /**
     * Sets given name field.
     *
     * @param string|null $value
     */
    public function givenName(?string $value): self
    {
        $this->instance->setGivenName($value);
        return $this;
    }

    /**
     * Sets surname field.
     *
     * @param string|null $value
     */
    public function surname(?string $value): self
    {
        $this->instance->setSurname($value);
        return $this;
    }

    /**
     * Sets middle name field.
     *
     * @param string|null $value
     */
    public function middleName(?string $value): self
    {
        $this->instance->setMiddleName($value);
        return $this;
    }

    /**
     * Sets suffix field.
     *
     * @param string|null $value
     */
    public function suffix(?string $value): self
    {
        $this->instance->setSuffix($value);
        return $this;
    }

    /**
     * Sets full name field.
     *
     * @param string|null $value
     */
    public function fullName(?string $value): self
    {
        $this->instance->setFullName($value);
        return $this;
    }

    /**
     * Initializes a new Subscription Payer Name object.
     */
    public function build(): SubscriptionPayerName
    {
        return CoreHelper::clone($this->instance);
    }
}
