<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\AuctionInformation;
use PaypalServerSdkLib\Models\CartInformation;
use PaypalServerSdkLib\Models\IncentiveInformation;
use PaypalServerSdkLib\Models\PayerInformation;
use PaypalServerSdkLib\Models\ShippingInformation;
use PaypalServerSdkLib\Models\StoreInformation;
use PaypalServerSdkLib\Models\TransactionDetails;
use PaypalServerSdkLib\Models\TransactionInformation;

/**
 * Builder for model TransactionDetails
 *
 * @see TransactionDetails
 */
class TransactionDetailsBuilder
{
    /**
     * @var TransactionDetails
     */
    private $instance;

    private function __construct(TransactionDetails $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Transaction Details Builder object.
     */
    public static function init(): self
    {
        return new self(new TransactionDetails());
    }

    /**
     * Sets transaction info field.
     *
     * @param TransactionInformation|null $value
     */
    public function transactionInfo(?TransactionInformation $value): self
    {
        $this->instance->setTransactionInfo($value);
        return $this;
    }

    /**
     * Sets payer info field.
     *
     * @param PayerInformation|null $value
     */
    public function payerInfo(?PayerInformation $value): self
    {
        $this->instance->setPayerInfo($value);
        return $this;
    }

    /**
     * Sets shipping info field.
     *
     * @param ShippingInformation|null $value
     */
    public function shippingInfo(?ShippingInformation $value): self
    {
        $this->instance->setShippingInfo($value);
        return $this;
    }

    /**
     * Sets cart info field.
     *
     * @param CartInformation|null $value
     */
    public function cartInfo(?CartInformation $value): self
    {
        $this->instance->setCartInfo($value);
        return $this;
    }

    /**
     * Sets store info field.
     *
     * @param StoreInformation|null $value
     */
    public function storeInfo(?StoreInformation $value): self
    {
        $this->instance->setStoreInfo($value);
        return $this;
    }

    /**
     * Sets auction info field.
     *
     * @param AuctionInformation|null $value
     */
    public function auctionInfo(?AuctionInformation $value): self
    {
        $this->instance->setAuctionInfo($value);
        return $this;
    }

    /**
     * Sets incentive info field.
     *
     * @param IncentiveInformation|null $value
     */
    public function incentiveInfo(?IncentiveInformation $value): self
    {
        $this->instance->setIncentiveInfo($value);
        return $this;
    }

    /**
     * Initializes a new Transaction Details object.
     */
    public function build(): TransactionDetails
    {
        return CoreHelper::clone($this->instance);
    }
}
