<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\LinkDescription;
use PaypalServerSdkLib\Models\SubscriptionTransactionDetails;
use PaypalServerSdkLib\Models\TransactionsList;

/**
 * Builder for model TransactionsList
 *
 * @see TransactionsList
 */
class TransactionsListBuilder
{
    /**
     * @var TransactionsList
     */
    private $instance;

    private function __construct(TransactionsList $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Transactions List Builder object.
     */
    public static function init(): self
    {
        return new self(new TransactionsList());
    }

    /**
     * Sets transactions field.
     *
     * @param SubscriptionTransactionDetails[]|null $value
     */
    public function transactions(?array $value): self
    {
        $this->instance->setTransactions($value);
        return $this;
    }

    /**
     * Sets total items field.
     *
     * @param int|null $value
     */
    public function totalItems(?int $value): self
    {
        $this->instance->setTotalItems($value);
        return $this;
    }

    /**
     * Sets total pages field.
     *
     * @param int|null $value
     */
    public function totalPages(?int $value): self
    {
        $this->instance->setTotalPages($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param LinkDescription[]|null $value
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Initializes a new Transactions List object.
     */
    public function build(): TransactionsList
    {
        return CoreHelper::clone($this->instance);
    }
}
