<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\VaultResponseCustomer;

/**
 * Builder for model VaultResponseCustomer
 *
 * @see VaultResponseCustomer
 */
class VaultResponseCustomerBuilder
{
    /**
     * @var VaultResponseCustomer
     */
    private $instance;

    private function __construct(VaultResponseCustomer $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Vault Response Customer Builder object.
     */
    public static function init(): self
    {
        return new self(new VaultResponseCustomer());
    }

    /**
     * Sets id field.
     *
     * @param string|null $value
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets merchant customer id field.
     *
     * @param string|null $value
     */
    public function merchantCustomerId(?string $value): self
    {
        $this->instance->setMerchantCustomerId($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param array $value
     */
    public function links(array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Initializes a new Vault Response Customer object.
     */
    public function build(): VaultResponseCustomer
    {
        return CoreHelper::clone($this->instance);
    }
}
