<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\VenmoExperienceContext;

/**
 * Builder for model VenmoExperienceContext
 *
 * @see VenmoExperienceContext
 */
class VenmoExperienceContextBuilder
{
    /**
     * @var VenmoExperienceContext
     */
    private $instance;

    private function __construct(VenmoExperienceContext $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Venmo Experience Context Builder object.
     */
    public static function init(): self
    {
        return new self(new VenmoExperienceContext());
    }

    /**
     * Sets brand name field.
     *
     * @param string|null $value
     */
    public function brandName(?string $value): self
    {
        $this->instance->setBrandName($value);
        return $this;
    }

    /**
     * Sets shipping preference field.
     *
     * @param string|null $value
     */
    public function shippingPreference(?string $value): self
    {
        $this->instance->setShippingPreference($value);
        return $this;
    }

    /**
     * Sets vault instruction field.
     *
     * @param string|null $value
     */
    public function vaultInstruction(?string $value): self
    {
        $this->instance->setVaultInstruction($value);
        return $this;
    }

    /**
     * Sets user action field.
     *
     * @param string|null $value
     */
    public function userAction(?string $value): self
    {
        $this->instance->setUserAction($value);
        return $this;
    }

    /**
     * Initializes a new Venmo Experience Context object.
     */
    public function build(): VenmoExperienceContext
    {
        return CoreHelper::clone($this->instance);
    }
}
