<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CallbackConfiguration;
use PaypalServerSdkLib\Models\VenmoWalletExperienceContext;

/**
 * Builder for model VenmoWalletExperienceContext
 *
 * @see VenmoWalletExperienceContext
 */
class VenmoWalletExperienceContextBuilder
{
    /**
     * @var VenmoWalletExperienceContext
     */
    private $instance;

    private function __construct(VenmoWalletExperienceContext $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Venmo Wallet Experience Context Builder object.
     */
    public static function init(): self
    {
        return new self(new VenmoWalletExperienceContext());
    }

    /**
     * Sets brand name field.
     *
     * @param string|null $value
     */
    public function brandName(?string $value): self
    {
        $this->instance->setBrandName($value);
        return $this;
    }

    /**
     * Sets shipping preference field.
     *
     * @param string|null $value
     */
    public function shippingPreference(?string $value): self
    {
        $this->instance->setShippingPreference($value);
        return $this;
    }

    /**
     * Sets order update callback config field.
     *
     * @param CallbackConfiguration|null $value
     */
    public function orderUpdateCallbackConfig(?CallbackConfiguration $value): self
    {
        $this->instance->setOrderUpdateCallbackConfig($value);
        return $this;
    }

    /**
     * Sets user action field.
     *
     * @param string|null $value
     */
    public function userAction(?string $value): self
    {
        $this->instance->setUserAction($value);
        return $this;
    }

    /**
     * Initializes a new Venmo Wallet Experience Context object.
     */
    public function build(): VenmoWalletExperienceContext
    {
        return CoreHelper::clone($this->instance);
    }
}
