<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Any additional payment instructions to be consider during payment processing. This processing
 * instruction is applicable for Capturing an order or Authorizing an Order.
 */
class CapturePaymentInstruction implements \JsonSerializable
{
    /**
     * @var PlatformFee[]|null
     */
    private $platformFees;

    /**
     * @var string|null
     */
    private $disbursementMode = DisbursementMode::INSTANT;

    /**
     * @var string|null
     */
    private $payeeReceivableFxRateId;

    /**
     * Returns Platform Fees.
     * An array of platform or partner fees, commissions, or brokerage fees that associated with the
     * captured payment.
     *
     * @return PlatformFee[]|null
     */
    public function getPlatformFees(): ?array
    {
        return $this->platformFees;
    }

    /**
     * Sets Platform Fees.
     * An array of platform or partner fees, commissions, or brokerage fees that associated with the
     * captured payment.
     *
     * @maps platform_fees
     *
     * @param PlatformFee[]|null $platformFees
     */
    public function setPlatformFees(?array $platformFees): void
    {
        $this->platformFees = $platformFees;
    }

    /**
     * Returns Disbursement Mode.
     * The funds that are held on behalf of the merchant.
     */
    public function getDisbursementMode(): ?string
    {
        return $this->disbursementMode;
    }

    /**
     * Sets Disbursement Mode.
     * The funds that are held on behalf of the merchant.
     *
     * @maps disbursement_mode
     */
    public function setDisbursementMode(?string $disbursementMode): void
    {
        $this->disbursementMode = $disbursementMode;
    }

    /**
     * Returns Payee Receivable Fx Rate Id.
     * FX identifier generated returned by PayPal to be used for payment processing in order to honor FX
     * rate (for eligible integrations) to be used when amount is settled/received into the payee account.
     */
    public function getPayeeReceivableFxRateId(): ?string
    {
        return $this->payeeReceivableFxRateId;
    }

    /**
     * Sets Payee Receivable Fx Rate Id.
     * FX identifier generated returned by PayPal to be used for payment processing in order to honor FX
     * rate (for eligible integrations) to be used when amount is settled/received into the payee account.
     *
     * @maps payee_receivable_fx_rate_id
     */
    public function setPayeeReceivableFxRateId(?string $payeeReceivableFxRateId): void
    {
        $this->payeeReceivableFxRateId = $payeeReceivableFxRateId;
    }

    /**
     * Converts the CapturePaymentInstruction object to a human-readable string representation.
     *
     * @return string The string representation of the CapturePaymentInstruction object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'CapturePaymentInstruction',
            [
                'platformFees' => $this->platformFees,
                'disbursementMode' => $this->disbursementMode,
                'payeeReceivableFxRateId' => $this->payeeReceivableFxRateId
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->platformFees)) {
            $json['platform_fees']               = $this->platformFees;
        }
        if (isset($this->disbursementMode)) {
            $json['disbursement_mode']           = $this->disbursementMode;
        }
        if (isset($this->payeeReceivableFxRateId)) {
            $json['payee_receivable_fx_rate_id'] = $this->payeeReceivableFxRateId;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
