<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The charge amount from the subscriber.
 */
class CaptureSubscriptionRequest implements \JsonSerializable
{
    /**
     * @var string
     */
    private $note;

    /**
     * @var string
     */
    private $captureType;

    /**
     * @var Money
     */
    private $amount;

    /**
     * @param string $note
     * @param string $captureType
     * @param Money $amount
     */
    public function __construct(string $note, string $captureType, Money $amount)
    {
        $this->note = $note;
        $this->captureType = $captureType;
        $this->amount = $amount;
    }

    /**
     * Returns Note.
     * The reason or note for the subscription charge.
     */
    public function getNote(): string
    {
        return $this->note;
    }

    /**
     * Sets Note.
     * The reason or note for the subscription charge.
     *
     * @required
     * @maps note
     */
    public function setNote(string $note): void
    {
        $this->note = $note;
    }

    /**
     * Returns Capture Type.
     * The type of capture.
     */
    public function getCaptureType(): string
    {
        return $this->captureType;
    }

    /**
     * Sets Capture Type.
     * The type of capture.
     *
     * @required
     * @maps capture_type
     */
    public function setCaptureType(string $captureType): void
    {
        $this->captureType = $captureType;
    }

    /**
     * Returns Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getAmount(): Money
    {
        return $this->amount;
    }

    /**
     * Sets Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @required
     * @maps amount
     */
    public function setAmount(Money $amount): void
    {
        $this->amount = $amount;
    }

    /**
     * Converts the CaptureSubscriptionRequest object to a human-readable string representation.
     *
     * @return string The string representation of the CaptureSubscriptionRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'CaptureSubscriptionRequest',
            ['note' => $this->note, 'captureType' => $this->captureType, 'amount' => $this->amount]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['note']         = $this->note;
        $json['capture_type'] = $this->captureType;
        $json['amount']       = $this->amount;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
