<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Card Verification details including the authorization details and 3D SECURE details.
 */
class CardVerificationDetails implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $networkTransactionId;

    /**
     * @var string|null
     */
    private $date;

    /**
     * @var string|null
     */
    private $network;

    /**
     * @var string|null
     */
    private $time;

    /**
     * @var Money|null
     */
    private $amount;

    /**
     * @var CardVerificationProcessorResponse|null
     */
    private $processorResponse;

    /**
     * @var mixed
     */
    private $threeDSecure;

    /**
     * Returns Network Transaction Id.
     * DEPRECATED. This field is DEPRECATED. Please find the network transaction id data in the 'id' field
     * under the 'network_transaction_reference' object instead of the 'verification' object.
     */
    public function getNetworkTransactionId(): ?string
    {
        return $this->networkTransactionId;
    }

    /**
     * Sets Network Transaction Id.
     * DEPRECATED. This field is DEPRECATED. Please find the network transaction id data in the 'id' field
     * under the 'network_transaction_reference' object instead of the 'verification' object.
     *
     * @maps network_transaction_id
     */
    public function setNetworkTransactionId(?string $networkTransactionId): void
    {
        $this->networkTransactionId = $networkTransactionId;
    }

    /**
     * Returns Date.
     * DEPRECATED. This field is DEPRECATED. Please find the date data in the 'date' field under the
     * 'network_transaction_reference' object instead of the 'verification' object.
     */
    public function getDate(): ?string
    {
        return $this->date;
    }

    /**
     * Sets Date.
     * DEPRECATED. This field is DEPRECATED. Please find the date data in the 'date' field under the
     * 'network_transaction_reference' object instead of the 'verification' object.
     *
     * @maps date
     */
    public function setDate(?string $date): void
    {
        $this->date = $date;
    }

    /**
     * Returns Network.
     * DEPRECATED. This field is DEPRECATED. Please find the network data in the 'network' field under the
     * 'network_transaction_reference' object instead of the 'verification' object.
     */
    public function getNetwork(): ?string
    {
        return $this->network;
    }

    /**
     * Sets Network.
     * DEPRECATED. This field is DEPRECATED. Please find the network data in the 'network' field under the
     * 'network_transaction_reference' object instead of the 'verification' object.
     *
     * @maps network
     */
    public function setNetwork(?string $network): void
    {
        $this->network = $network;
    }

    /**
     * Returns Time.
     * DEPRECATED. This field is DEPRECATED. Please find the time data in the 'time' field under the
     * 'network_transaction_reference' object instead of the 'verification' object.
     */
    public function getTime(): ?string
    {
        return $this->time;
    }

    /**
     * Sets Time.
     * DEPRECATED. This field is DEPRECATED. Please find the time data in the 'time' field under the
     * 'network_transaction_reference' object instead of the 'verification' object.
     *
     * @maps time
     */
    public function setTime(?string $time): void
    {
        $this->time = $time;
    }

    /**
     * Returns Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getAmount(): ?Money
    {
        return $this->amount;
    }

    /**
     * Sets Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps amount
     */
    public function setAmount(?Money $amount): void
    {
        $this->amount = $amount;
    }

    /**
     * Returns Processor Response.
     * The processor response information for payment requests, such as direct credit card transactions.
     */
    public function getProcessorResponse(): ?CardVerificationProcessorResponse
    {
        return $this->processorResponse;
    }

    /**
     * Sets Processor Response.
     * The processor response information for payment requests, such as direct credit card transactions.
     *
     * @maps processor_response
     */
    public function setProcessorResponse(?CardVerificationProcessorResponse $processorResponse): void
    {
        $this->processorResponse = $processorResponse;
    }

    /**
     * Returns Three D Secure.
     * DEPRECATED. This field is DEPRECATED. Please find the 3D secure authentication data in the
     * 'three_d_secure' object under the 'authentication_result' object instead of the 'verification'
     * object.
     *
     * @return mixed
     */
    public function getThreeDSecure()
    {
        return $this->threeDSecure;
    }

    /**
     * Sets Three D Secure.
     * DEPRECATED. This field is DEPRECATED. Please find the 3D secure authentication data in the
     * 'three_d_secure' object under the 'authentication_result' object instead of the 'verification'
     * object.
     *
     * @maps three_d_secure
     *
     * @param mixed $threeDSecure
     */
    public function setThreeDSecure($threeDSecure): void
    {
        $this->threeDSecure = $threeDSecure;
    }

    /**
     * Converts the CardVerificationDetails object to a human-readable string representation.
     *
     * @return string The string representation of the CardVerificationDetails object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'CardVerificationDetails',
            [
                'networkTransactionId' => $this->networkTransactionId,
                'date' => $this->date,
                'network' => $this->network,
                'time' => $this->time,
                'amount' => $this->amount,
                'processorResponse' => $this->processorResponse,
                'threeDSecure' => $this->threeDSecure
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->networkTransactionId)) {
            $json['network_transaction_id'] = $this->networkTransactionId;
        }
        if (isset($this->date)) {
            $json['date']                   = $this->date;
        }
        if (isset($this->network)) {
            $json['network']                = $this->network;
        }
        if (isset($this->time)) {
            $json['time']                   = $this->time;
        }
        if (isset($this->amount)) {
            $json['amount']                 = $this->amount;
        }
        if (isset($this->processorResponse)) {
            $json['processor_response']     = $this->processorResponse;
        }
        if (isset($this->threeDSecure)) {
            $json['three_d_secure']         = $this->threeDSecure;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
