<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * A checkout option as a name-and-value pair.
 */
class CheckoutOption implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $checkoutOptionName;

    /**
     * @var string|null
     */
    private $checkoutOptionValue;

    /**
     * Returns Checkout Option Name.
     * The checkout option name, such as `color` or `texture`.
     */
    public function getCheckoutOptionName(): ?string
    {
        return $this->checkoutOptionName;
    }

    /**
     * Sets Checkout Option Name.
     * The checkout option name, such as `color` or `texture`.
     *
     * @maps checkout_option_name
     */
    public function setCheckoutOptionName(?string $checkoutOptionName): void
    {
        $this->checkoutOptionName = $checkoutOptionName;
    }

    /**
     * Returns Checkout Option Value.
     * The checkout option value. For example, the checkout option `color` might be `blue` or `red` while
     * the checkout option `texture` might be `smooth` or `rippled`.
     */
    public function getCheckoutOptionValue(): ?string
    {
        return $this->checkoutOptionValue;
    }

    /**
     * Sets Checkout Option Value.
     * The checkout option value. For example, the checkout option `color` might be `blue` or `red` while
     * the checkout option `texture` might be `smooth` or `rippled`.
     *
     * @maps checkout_option_value
     */
    public function setCheckoutOptionValue(?string $checkoutOptionValue): void
    {
        $this->checkoutOptionValue = $checkoutOptionValue;
    }

    /**
     * Converts the CheckoutOption object to a human-readable string representation.
     *
     * @return string The string representation of the CheckoutOption object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'CheckoutOption',
            [
                'checkoutOptionName' => $this->checkoutOptionName,
                'checkoutOptionValue' => $this->checkoutOptionValue
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->checkoutOptionName)) {
            $json['checkout_option_name']  = $this->checkoutOptionName;
        }
        if (isset($this->checkoutOptionValue)) {
            $json['checkout_option_value'] = $this->checkoutOptionValue;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
