<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The create subscription request details.
 */
class CreateSubscriptionRequest implements \JsonSerializable
{
    /**
     * @var string
     */
    private $planId;

    /**
     * @var string|null
     */
    private $startTime;

    /**
     * @var string|null
     */
    private $quantity;

    /**
     * @var Money|null
     */
    private $shippingAmount;

    /**
     * @var SubscriberRequest|null
     */
    private $subscriber;

    /**
     * @var bool|null
     */
    private $autoRenewal = false;

    /**
     * @var SubscriptionApplicationContext|null
     */
    private $applicationContext;

    /**
     * @var string|null
     */
    private $customId;

    /**
     * @var PlanOverride|null
     */
    private $plan;

    /**
     * @param string $planId
     */
    public function __construct(string $planId)
    {
        $this->planId = $planId;
    }

    /**
     * Returns Plan Id.
     * The ID of the plan.
     */
    public function getPlanId(): string
    {
        return $this->planId;
    }

    /**
     * Sets Plan Id.
     * The ID of the plan.
     *
     * @required
     * @maps plan_id
     */
    public function setPlanId(string $planId): void
    {
        $this->planId = $planId;
    }

    /**
     * Returns Start Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getStartTime(): ?string
    {
        return $this->startTime;
    }

    /**
     * Sets Start Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps start_time
     */
    public function setStartTime(?string $startTime): void
    {
        $this->startTime = $startTime;
    }

    /**
     * Returns Quantity.
     * The quantity of the product in the subscription.
     */
    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    /**
     * Sets Quantity.
     * The quantity of the product in the subscription.
     *
     * @maps quantity
     */
    public function setQuantity(?string $quantity): void
    {
        $this->quantity = $quantity;
    }

    /**
     * Returns Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getShippingAmount(): ?Money
    {
        return $this->shippingAmount;
    }

    /**
     * Sets Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps shipping_amount
     */
    public function setShippingAmount(?Money $shippingAmount): void
    {
        $this->shippingAmount = $shippingAmount;
    }

    /**
     * Returns Subscriber.
     * The subscriber request information .
     */
    public function getSubscriber(): ?SubscriberRequest
    {
        return $this->subscriber;
    }

    /**
     * Sets Subscriber.
     * The subscriber request information .
     *
     * @maps subscriber
     */
    public function setSubscriber(?SubscriberRequest $subscriber): void
    {
        $this->subscriber = $subscriber;
    }

    /**
     * Returns Auto Renewal.
     * DEPRECATED. Indicates whether the subscription auto-renews after the billing cycles complete.
     */
    public function getAutoRenewal(): ?bool
    {
        return $this->autoRenewal;
    }

    /**
     * Sets Auto Renewal.
     * DEPRECATED. Indicates whether the subscription auto-renews after the billing cycles complete.
     *
     * @maps auto_renewal
     */
    public function setAutoRenewal(?bool $autoRenewal): void
    {
        $this->autoRenewal = $autoRenewal;
    }

    /**
     * Returns Application Context.
     * DEPRECATED. The application context, which customizes the payer experience during the subscription
     * approval process with PayPal.
     */
    public function getApplicationContext(): ?SubscriptionApplicationContext
    {
        return $this->applicationContext;
    }

    /**
     * Sets Application Context.
     * DEPRECATED. The application context, which customizes the payer experience during the subscription
     * approval process with PayPal.
     *
     * @maps application_context
     */
    public function setApplicationContext(?SubscriptionApplicationContext $applicationContext): void
    {
        $this->applicationContext = $applicationContext;
    }

    /**
     * Returns Custom Id.
     * The custom id for the subscription. Can be invoice id.
     */
    public function getCustomId(): ?string
    {
        return $this->customId;
    }

    /**
     * Sets Custom Id.
     * The custom id for the subscription. Can be invoice id.
     *
     * @maps custom_id
     */
    public function setCustomId(?string $customId): void
    {
        $this->customId = $customId;
    }

    /**
     * Returns Plan.
     * An inline plan object to customise the subscription. You can override plan level default attributes
     * by providing customised values for the subscription in this object.
     */
    public function getPlan(): ?PlanOverride
    {
        return $this->plan;
    }

    /**
     * Sets Plan.
     * An inline plan object to customise the subscription. You can override plan level default attributes
     * by providing customised values for the subscription in this object.
     *
     * @maps plan
     */
    public function setPlan(?PlanOverride $plan): void
    {
        $this->plan = $plan;
    }

    /**
     * Converts the CreateSubscriptionRequest object to a human-readable string representation.
     *
     * @return string The string representation of the CreateSubscriptionRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'CreateSubscriptionRequest',
            [
                'planId' => $this->planId,
                'startTime' => $this->startTime,
                'quantity' => $this->quantity,
                'shippingAmount' => $this->shippingAmount,
                'subscriber' => $this->subscriber,
                'autoRenewal' => $this->autoRenewal,
                'applicationContext' => $this->applicationContext,
                'customId' => $this->customId,
                'plan' => $this->plan
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['plan_id']                 = $this->planId;
        if (isset($this->startTime)) {
            $json['start_time']          = $this->startTime;
        }
        if (isset($this->quantity)) {
            $json['quantity']            = $this->quantity;
        }
        if (isset($this->shippingAmount)) {
            $json['shipping_amount']     = $this->shippingAmount;
        }
        if (isset($this->subscriber)) {
            $json['subscriber']          = $this->subscriber;
        }
        if (isset($this->autoRenewal)) {
            $json['auto_renewal']        = $this->autoRenewal;
        }
        if (isset($this->applicationContext)) {
            $json['application_context'] = $this->applicationContext;
        }
        if (isset($this->customId)) {
            $json['custom_id']           = $this->customId;
        }
        if (isset($this->plan)) {
            $json['plan']                = $this->plan;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
