<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

/**
 * The card verification value code for for Visa, Discover, Mastercard, or American Express.
 */
class CvvCode
{
    /**
     * For Visa, Mastercard, Discover, or American Express, error - unrecognized or unknown response.
     */
    public const CVV_E = 'E';

    /**
     * For Visa, Mastercard, Discover, or American Express, invalid or null.
     */
    public const CVV_I = 'I';

    /**
     * For Visa, Mastercard, Discover, or American Express, the CVV2/CSC matches.
     */
    public const CVV_M = 'M';

    /**
     * For Visa, Mastercard, Discover, or American Express, the CVV2/CSC does not match.
     */
    public const CVV_N = 'N';

    /**
     * For Visa, Mastercard, Discover, or American Express, it was not processed.
     */
    public const CVV_P = 'P';

    /**
     * For Visa, Mastercard, Discover, or American Express, the service is not supported.
     */
    public const CVV_S = 'S';

    /**
     * For Visa, Mastercard, Discover, or American Express, unknown - the issuer is not certified.
     */
    public const CVV_U = 'U';

    /**
     * For Visa, Mastercard, Discover, or American Express, no response. For Maestro, the service is not
     * available.
     */
    public const CVV_X = 'X';

    /**
     * For Visa, Mastercard, Discover, or American Express, error.
     */
    public const ENUM_ALL_OTHERS = 'All others';

    /**
     * For Maestro, the CVV2 matched.
     */
    public const CVV_0 = '0';

    /**
     * For Maestro, the CVV2 did not match.
     */
    public const CVV_1 = '1';

    /**
     * For Maestro, the merchant has not implemented CVV2 code handling.
     */
    public const CVV_2 = '2';

    /**
     * For Maestro, the merchant has indicated that CVV2 is not present on card.
     */
    public const CVV_3 = '3';

    /**
     * For Maestro, the service is not available.
     */
    public const CVV_4 = '4';
}
