<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Buyer's mobile web browser context to app switch to the PayPal consumer app.
 */
class MobileWebContext implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $returnFlow = MobileReturnFlow::AUTO;

    /**
     * @var string|null
     */
    private $buyerUserAgent;

    /**
     * Returns Return Flow.
     * Merchant preference on how the buyer can navigate back to merchant website post approving the
     * transaction on the PayPal App.
     */
    public function getReturnFlow(): ?string
    {
        return $this->returnFlow;
    }

    /**
     * Sets Return Flow.
     * Merchant preference on how the buyer can navigate back to merchant website post approving the
     * transaction on the PayPal App.
     *
     * @maps return_flow
     */
    public function setReturnFlow(?string $returnFlow): void
    {
        $this->returnFlow = $returnFlow;
    }

    /**
     * Returns Buyer User Agent.
     * User agent from the request originating from the buyer's device. This will be used to identify the
     * buyer's operating system and browser versions. NOTE: Merchants must not alter or modify the buyer's
     * device user agent.
     */
    public function getBuyerUserAgent(): ?string
    {
        return $this->buyerUserAgent;
    }

    /**
     * Sets Buyer User Agent.
     * User agent from the request originating from the buyer's device. This will be used to identify the
     * buyer's operating system and browser versions. NOTE: Merchants must not alter or modify the buyer's
     * device user agent.
     *
     * @maps buyer_user_agent
     */
    public function setBuyerUserAgent(?string $buyerUserAgent): void
    {
        $this->buyerUserAgent = $buyerUserAgent;
    }

    /**
     * Converts the MobileWebContext object to a human-readable string representation.
     *
     * @return string The string representation of the MobileWebContext object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'MobileWebContext',
            ['returnFlow' => $this->returnFlow, 'buyerUserAgent' => $this->buyerUserAgent]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->returnFlow)) {
            $json['return_flow']      = $this->returnFlow;
        }
        if (isset($this->buyerUserAgent)) {
            $json['buyer_user_agent'] = $this->buyerUserAgent;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
