<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The one-time charge info at the time of checkout.
 */
class OneTimeCharge implements \JsonSerializable
{
    /**
     * @var Money|null
     */
    private $setupFee;

    /**
     * @var Money|null
     */
    private $shippingAmount;

    /**
     * @var Money|null
     */
    private $taxes;

    /**
     * @var Money|null
     */
    private $productPrice;

    /**
     * @var Money|null
     */
    private $subtotal;

    /**
     * @var Money
     */
    private $totalAmount;

    /**
     * @param Money $totalAmount
     */
    public function __construct(Money $totalAmount)
    {
        $this->totalAmount = $totalAmount;
    }

    /**
     * Returns Setup Fee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getSetupFee(): ?Money
    {
        return $this->setupFee;
    }

    /**
     * Sets Setup Fee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps setup_fee
     */
    public function setSetupFee(?Money $setupFee): void
    {
        $this->setupFee = $setupFee;
    }

    /**
     * Returns Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getShippingAmount(): ?Money
    {
        return $this->shippingAmount;
    }

    /**
     * Sets Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps shipping_amount
     */
    public function setShippingAmount(?Money $shippingAmount): void
    {
        $this->shippingAmount = $shippingAmount;
    }

    /**
     * Returns Taxes.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getTaxes(): ?Money
    {
        return $this->taxes;
    }

    /**
     * Sets Taxes.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps taxes
     */
    public function setTaxes(?Money $taxes): void
    {
        $this->taxes = $taxes;
    }

    /**
     * Returns Product Price.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getProductPrice(): ?Money
    {
        return $this->productPrice;
    }

    /**
     * Sets Product Price.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps product_price
     */
    public function setProductPrice(?Money $productPrice): void
    {
        $this->productPrice = $productPrice;
    }

    /**
     * Returns Subtotal.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getSubtotal(): ?Money
    {
        return $this->subtotal;
    }

    /**
     * Sets Subtotal.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps subtotal
     */
    public function setSubtotal(?Money $subtotal): void
    {
        $this->subtotal = $subtotal;
    }

    /**
     * Returns Total Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getTotalAmount(): Money
    {
        return $this->totalAmount;
    }

    /**
     * Sets Total Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @required
     * @maps total_amount
     */
    public function setTotalAmount(Money $totalAmount): void
    {
        $this->totalAmount = $totalAmount;
    }

    /**
     * Converts the OneTimeCharge object to a human-readable string representation.
     *
     * @return string The string representation of the OneTimeCharge object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'OneTimeCharge',
            [
                'setupFee' => $this->setupFee,
                'shippingAmount' => $this->shippingAmount,
                'taxes' => $this->taxes,
                'productPrice' => $this->productPrice,
                'subtotal' => $this->subtotal,
                'totalAmount' => $this->totalAmount
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->setupFee)) {
            $json['setup_fee']       = $this->setupFee;
        }
        if (isset($this->shippingAmount)) {
            $json['shipping_amount'] = $this->shippingAmount;
        }
        if (isset($this->taxes)) {
            $json['taxes']           = $this->taxes;
        }
        if (isset($this->productPrice)) {
            $json['product_price']   = $this->productPrice;
        }
        if (isset($this->subtotal)) {
            $json['subtotal']        = $this->subtotal;
        }
        $json['total_amount']        = $this->totalAmount;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
