<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Customizes the payer experience during the approval process for the payment with PayPal. Note:
 * Partners and Marketplaces might configure brand_name and shipping_preference during partner account
 * setup, which overrides the request values.
 */
class OrderApplicationContext implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $brandName;

    /**
     * @var string|null
     */
    private $locale;

    /**
     * @var string|null
     */
    private $landingPage = OrderApplicationContextLandingPage::NO_PREFERENCE;

    /**
     * @var string|null
     */
    private $shippingPreference = OrderApplicationContextShippingPreference::GET_FROM_FILE;

    /**
     * @var string|null
     */
    private $userAction = OrderApplicationContextUserAction::CONTINUE_;

    /**
     * @var PaymentMethodPreference|null
     */
    private $paymentMethod;

    /**
     * @var string|null
     */
    private $returnUrl;

    /**
     * @var string|null
     */
    private $cancelUrl;

    /**
     * @var StoredPaymentSource|null
     */
    private $storedPaymentSource;

    /**
     * Returns Brand Name.
     * DEPRECATED. The label that overrides the business name in the PayPal account on the PayPal site. The
     * fields in `application_context` are now available in the `experience_context` object under the
     * `payment_source` which supports them (eg. `payment_source.paypal.experience_context.brand_name`).
     * Please specify this field in the `experience_context` object instead of the `application_context`
     * object.
     */
    public function getBrandName(): ?string
    {
        return $this->brandName;
    }

    /**
     * Sets Brand Name.
     * DEPRECATED. The label that overrides the business name in the PayPal account on the PayPal site. The
     * fields in `application_context` are now available in the `experience_context` object under the
     * `payment_source` which supports them (eg. `payment_source.paypal.experience_context.brand_name`).
     * Please specify this field in the `experience_context` object instead of the `application_context`
     * object.
     *
     * @maps brand_name
     */
    public function setBrandName(?string $brandName): void
    {
        $this->brandName = $brandName;
    }

    /**
     * Returns Locale.
     * DEPRECATED. The BCP 47-formatted locale of pages that the PayPal payment experience shows. PayPal
     * supports a five-character code. For example, `da-DK`, `he-IL`, `id-ID`, `ja-JP`, `no-NO`, `pt-BR`,
     * `ru-RU`, `sv-SE`, `th-TH`, `zh-CN`, `zh-HK`, or `zh-TW`.  The fields in `application_context` are
     * now available in the `experience_context` object under the `payment_source` which supports them (eg.
     * `payment_source.paypal.experience_context.locale`). Please specify this field in the
     * `experience_context` object instead of the `application_context` object.
     */
    public function getLocale(): ?string
    {
        return $this->locale;
    }

    /**
     * Sets Locale.
     * DEPRECATED. The BCP 47-formatted locale of pages that the PayPal payment experience shows. PayPal
     * supports a five-character code. For example, `da-DK`, `he-IL`, `id-ID`, `ja-JP`, `no-NO`, `pt-BR`,
     * `ru-RU`, `sv-SE`, `th-TH`, `zh-CN`, `zh-HK`, or `zh-TW`.  The fields in `application_context` are
     * now available in the `experience_context` object under the `payment_source` which supports them (eg.
     * `payment_source.paypal.experience_context.locale`). Please specify this field in the
     * `experience_context` object instead of the `application_context` object.
     *
     * @maps locale
     */
    public function setLocale(?string $locale): void
    {
        $this->locale = $locale;
    }

    /**
     * Returns Landing Page.
     * DEPRECATED. DEPRECATED. The type of landing page to show on the PayPal site for customer checkout.
     * The fields in `application_context` are now available in the `experience_context` object under the
     * `payment_source` which supports them (eg. `payment_source.paypal.experience_context.landing_page`).
     * Please specify this field in the `experience_context` object instead of the `application_context`
     * object.
     */
    public function getLandingPage(): ?string
    {
        return $this->landingPage;
    }

    /**
     * Sets Landing Page.
     * DEPRECATED. DEPRECATED. The type of landing page to show on the PayPal site for customer checkout.
     * The fields in `application_context` are now available in the `experience_context` object under the
     * `payment_source` which supports them (eg. `payment_source.paypal.experience_context.landing_page`).
     * Please specify this field in the `experience_context` object instead of the `application_context`
     * object.
     *
     * @maps landing_page
     */
    public function setLandingPage(?string $landingPage): void
    {
        $this->landingPage = $landingPage;
    }

    /**
     * Returns Shipping Preference.
     * DEPRECATED. DEPRECATED. The shipping preference: Displays the shipping address to the customer.
     * Enables the customer to choose an address on the PayPal site. Restricts the customer from changing
     * the address during the payment-approval process. .  The fields in `application_context` are now
     * available in the `experience_context` object under the `payment_source` which supports them (eg.
     * `payment_source.paypal.experience_context.shipping_preference`). Please specify this field in the
     * `experience_context` object instead of the `application_context` object.
     */
    public function getShippingPreference(): ?string
    {
        return $this->shippingPreference;
    }

    /**
     * Sets Shipping Preference.
     * DEPRECATED. DEPRECATED. The shipping preference: Displays the shipping address to the customer.
     * Enables the customer to choose an address on the PayPal site. Restricts the customer from changing
     * the address during the payment-approval process. .  The fields in `application_context` are now
     * available in the `experience_context` object under the `payment_source` which supports them (eg.
     * `payment_source.paypal.experience_context.shipping_preference`). Please specify this field in the
     * `experience_context` object instead of the `application_context` object.
     *
     * @maps shipping_preference
     */
    public function setShippingPreference(?string $shippingPreference): void
    {
        $this->shippingPreference = $shippingPreference;
    }

    /**
     * Returns User Action.
     * DEPRECATED. Configures a Continue or Pay Now checkout flow.  The fields in `application_context` are
     * now available in the `experience_context` object under the `payment_source` which supports them (eg.
     * `payment_source.paypal.experience_context.user_action`). Please specify this field in the
     * `experience_context` object instead of the `application_context` object.
     */
    public function getUserAction(): ?string
    {
        return $this->userAction;
    }

    /**
     * Sets User Action.
     * DEPRECATED. Configures a Continue or Pay Now checkout flow.  The fields in `application_context` are
     * now available in the `experience_context` object under the `payment_source` which supports them (eg.
     * `payment_source.paypal.experience_context.user_action`). Please specify this field in the
     * `experience_context` object instead of the `application_context` object.
     *
     * @maps user_action
     */
    public function setUserAction(?string $userAction): void
    {
        $this->userAction = $userAction;
    }

    /**
     * Returns Payment Method.
     * DEPRECATED. The customer and merchant payment preferences. The fields in `application_context` are
     * now available in the `experience_context` object under the `payment_source` which supports them (eg.
     * `payment_source.paypal.experience_context.payment_method_selected`). Please specify this field in
     * the `experience_context` object instead of the `application_context` object..
     */
    public function getPaymentMethod(): ?PaymentMethodPreference
    {
        return $this->paymentMethod;
    }

    /**
     * Sets Payment Method.
     * DEPRECATED. The customer and merchant payment preferences. The fields in `application_context` are
     * now available in the `experience_context` object under the `payment_source` which supports them (eg.
     * `payment_source.paypal.experience_context.payment_method_selected`). Please specify this field in
     * the `experience_context` object instead of the `application_context` object..
     *
     * @maps payment_method
     */
    public function setPaymentMethod(?PaymentMethodPreference $paymentMethod): void
    {
        $this->paymentMethod = $paymentMethod;
    }

    /**
     * Returns Return Url.
     * DEPRECATED. The URL where the customer is redirected after the customer approves the payment. The
     * fields in `application_context` are now available in the `experience_context` object under the
     * `payment_source` which supports them (eg. `payment_source.paypal.experience_context.return_url`).
     * Please specify this field in the `experience_context` object instead of the `application_context`
     * object.
     */
    public function getReturnUrl(): ?string
    {
        return $this->returnUrl;
    }

    /**
     * Sets Return Url.
     * DEPRECATED. The URL where the customer is redirected after the customer approves the payment. The
     * fields in `application_context` are now available in the `experience_context` object under the
     * `payment_source` which supports them (eg. `payment_source.paypal.experience_context.return_url`).
     * Please specify this field in the `experience_context` object instead of the `application_context`
     * object.
     *
     * @maps return_url
     */
    public function setReturnUrl(?string $returnUrl): void
    {
        $this->returnUrl = $returnUrl;
    }

    /**
     * Returns Cancel Url.
     * DEPRECATED. The URL where the customer is redirected after the customer cancels the payment. The
     * fields in `application_context` are now available in the `experience_context` object under the
     * `payment_source` which supports them (eg. `payment_source.paypal.experience_context.cancel_url`).
     * Please specify this field in the `experience_context` object instead of the `application_context`
     * object.
     */
    public function getCancelUrl(): ?string
    {
        return $this->cancelUrl;
    }

    /**
     * Sets Cancel Url.
     * DEPRECATED. The URL where the customer is redirected after the customer cancels the payment. The
     * fields in `application_context` are now available in the `experience_context` object under the
     * `payment_source` which supports them (eg. `payment_source.paypal.experience_context.cancel_url`).
     * Please specify this field in the `experience_context` object instead of the `application_context`
     * object.
     *
     * @maps cancel_url
     */
    public function setCancelUrl(?string $cancelUrl): void
    {
        $this->cancelUrl = $cancelUrl;
    }

    /**
     * Returns Stored Payment Source.
     * DEPRECATED. Provides additional details to process a payment using a `payment_source` that has been
     * stored or is intended to be stored (also referred to as stored_credential or card-on-file).
     * Parameter compatibility: `payment_type=ONE_TIME` is compatible only with
     * `payment_initiator=CUSTOMER`. `usage=FIRST` is compatible only with `payment_initiator=CUSTOMER`.
     * `previous_transaction_reference` or `previous_network_transaction_reference` is compatible only with
     * `payment_initiator=MERCHANT`. Only one of the parameters - `previous_transaction_reference` and
     * `previous_network_transaction_reference` - can be present in the request. .  The fields in
     * `stored_payment_source` are now available in the `stored_credential` object under the
     * `payment_source` which supports them (eg. `payment_source.card.stored_credential.payment_initiator`).
     * Please specify this field in the `payment_source` object instead of the `application_context`
     * object.
     */
    public function getStoredPaymentSource(): ?StoredPaymentSource
    {
        return $this->storedPaymentSource;
    }

    /**
     * Sets Stored Payment Source.
     * DEPRECATED. Provides additional details to process a payment using a `payment_source` that has been
     * stored or is intended to be stored (also referred to as stored_credential or card-on-file).
     * Parameter compatibility: `payment_type=ONE_TIME` is compatible only with
     * `payment_initiator=CUSTOMER`. `usage=FIRST` is compatible only with `payment_initiator=CUSTOMER`.
     * `previous_transaction_reference` or `previous_network_transaction_reference` is compatible only with
     * `payment_initiator=MERCHANT`. Only one of the parameters - `previous_transaction_reference` and
     * `previous_network_transaction_reference` - can be present in the request. .  The fields in
     * `stored_payment_source` are now available in the `stored_credential` object under the
     * `payment_source` which supports them (eg. `payment_source.card.stored_credential.payment_initiator`).
     * Please specify this field in the `payment_source` object instead of the `application_context`
     * object.
     *
     * @maps stored_payment_source
     */
    public function setStoredPaymentSource(?StoredPaymentSource $storedPaymentSource): void
    {
        $this->storedPaymentSource = $storedPaymentSource;
    }

    /**
     * Converts the OrderApplicationContext object to a human-readable string representation.
     *
     * @return string The string representation of the OrderApplicationContext object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'OrderApplicationContext',
            [
                'brandName' => $this->brandName,
                'locale' => $this->locale,
                'landingPage' => $this->landingPage,
                'shippingPreference' => $this->shippingPreference,
                'userAction' => $this->userAction,
                'paymentMethod' => $this->paymentMethod,
                'returnUrl' => $this->returnUrl,
                'cancelUrl' => $this->cancelUrl,
                'storedPaymentSource' => $this->storedPaymentSource
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->brandName)) {
            $json['brand_name']            = $this->brandName;
        }
        if (isset($this->locale)) {
            $json['locale']                = $this->locale;
        }
        if (isset($this->landingPage)) {
            $json['landing_page']          = $this->landingPage;
        }
        if (isset($this->shippingPreference)) {
            $json['shipping_preference']   = $this->shippingPreference;
        }
        if (isset($this->userAction)) {
            $json['user_action']           = $this->userAction;
        }
        if (isset($this->paymentMethod)) {
            $json['payment_method']        = $this->paymentMethod;
        }
        if (isset($this->returnUrl)) {
            $json['return_url']            = $this->returnUrl;
        }
        if (isset($this->cancelUrl)) {
            $json['cancel_url']            = $this->cancelUrl;
        }
        if (isset($this->storedPaymentSource)) {
            $json['stored_payment_source'] = $this->storedPaymentSource;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
