<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The payment preferences to override at subscription level.
 */
class PaymentPreferencesOverride implements \JsonSerializable
{
    /**
     * @var bool|null
     */
    private $autoBillOutstanding;

    /**
     * @var Money|null
     */
    private $setupFee;

    /**
     * @var string|null
     */
    private $setupFeeFailureAction;

    /**
     * @var int|null
     */
    private $paymentFailureThreshold;

    /**
     * Returns Auto Bill Outstanding.
     * Indicates whether to automatically bill the outstanding amount in the next billing cycle.
     */
    public function getAutoBillOutstanding(): ?bool
    {
        return $this->autoBillOutstanding;
    }

    /**
     * Sets Auto Bill Outstanding.
     * Indicates whether to automatically bill the outstanding amount in the next billing cycle.
     *
     * @maps auto_bill_outstanding
     */
    public function setAutoBillOutstanding(?bool $autoBillOutstanding): void
    {
        $this->autoBillOutstanding = $autoBillOutstanding;
    }

    /**
     * Returns Setup Fee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getSetupFee(): ?Money
    {
        return $this->setupFee;
    }

    /**
     * Sets Setup Fee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps setup_fee
     */
    public function setSetupFee(?Money $setupFee): void
    {
        $this->setupFee = $setupFee;
    }

    /**
     * Returns Setup Fee Failure Action.
     * The action to take on the subscription if the initial payment for the setup fails.
     */
    public function getSetupFeeFailureAction(): ?string
    {
        return $this->setupFeeFailureAction;
    }

    /**
     * Sets Setup Fee Failure Action.
     * The action to take on the subscription if the initial payment for the setup fails.
     *
     * @maps setup_fee_failure_action
     */
    public function setSetupFeeFailureAction(?string $setupFeeFailureAction): void
    {
        $this->setupFeeFailureAction = $setupFeeFailureAction;
    }

    /**
     * Returns Payment Failure Threshold.
     * The maximum number of payment failures before a subscription is suspended. For example, if
     * `payment_failure_threshold` is `2`, the subscription automatically updates to the `SUSPEND` state if
     * two consecutive payments fail.
     */
    public function getPaymentFailureThreshold(): ?int
    {
        return $this->paymentFailureThreshold;
    }

    /**
     * Sets Payment Failure Threshold.
     * The maximum number of payment failures before a subscription is suspended. For example, if
     * `payment_failure_threshold` is `2`, the subscription automatically updates to the `SUSPEND` state if
     * two consecutive payments fail.
     *
     * @maps payment_failure_threshold
     */
    public function setPaymentFailureThreshold(?int $paymentFailureThreshold): void
    {
        $this->paymentFailureThreshold = $paymentFailureThreshold;
    }

    /**
     * Converts the PaymentPreferencesOverride object to a human-readable string representation.
     *
     * @return string The string representation of the PaymentPreferencesOverride object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PaymentPreferencesOverride',
            [
                'autoBillOutstanding' => $this->autoBillOutstanding,
                'setupFee' => $this->setupFee,
                'setupFeeFailureAction' => $this->setupFeeFailureAction,
                'paymentFailureThreshold' => $this->paymentFailureThreshold
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->autoBillOutstanding)) {
            $json['auto_bill_outstanding']     = $this->autoBillOutstanding;
        }
        if (isset($this->setupFee)) {
            $json['setup_fee']                 = $this->setupFee;
        }
        if (isset($this->setupFeeFailureAction)) {
            $json['setup_fee_failure_action']  = $this->setupFeeFailureAction;
        }
        if (isset($this->paymentFailureThreshold)) {
            $json['payment_failure_threshold'] = $this->paymentFailureThreshold;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
