<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Additional information necessary to evaluate the risk profile of a transaction.
 */
class RiskSupplementaryData implements \JsonSerializable
{
    /**
     * @var ParticipantMetadata|null
     */
    private $customer;

    /**
     * Returns Customer.
     * Profile information of the sender or receiver.
     */
    public function getCustomer(): ?ParticipantMetadata
    {
        return $this->customer;
    }

    /**
     * Sets Customer.
     * Profile information of the sender or receiver.
     *
     * @maps customer
     */
    public function setCustomer(?ParticipantMetadata $customer): void
    {
        $this->customer = $customer;
    }

    /**
     * Converts the RiskSupplementaryData object to a human-readable string representation.
     *
     * @return string The string representation of the RiskSupplementaryData object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('RiskSupplementaryData', ['customer' => $this->customer]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->customer)) {
            $json['customer'] = $this->customer;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
