<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The name of the party.
 */
class SubscriptionPayerName implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $prefix;

    /**
     * @var string|null
     */
    private $givenName;

    /**
     * @var string|null
     */
    private $surname;

    /**
     * @var string|null
     */
    private $middleName;

    /**
     * @var string|null
     */
    private $suffix;

    /**
     * @var string|null
     */
    private $fullName;

    /**
     * Returns Prefix.
     * The prefix, or title, to the party's name.
     */
    public function getPrefix(): ?string
    {
        return $this->prefix;
    }

    /**
     * Sets Prefix.
     * The prefix, or title, to the party's name.
     *
     * @maps prefix
     */
    public function setPrefix(?string $prefix): void
    {
        $this->prefix = $prefix;
    }

    /**
     * Returns Given Name.
     * When the party is a person, the party's given, or first, name.
     */
    public function getGivenName(): ?string
    {
        return $this->givenName;
    }

    /**
     * Sets Given Name.
     * When the party is a person, the party's given, or first, name.
     *
     * @maps given_name
     */
    public function setGivenName(?string $givenName): void
    {
        $this->givenName = $givenName;
    }

    /**
     * Returns Surname.
     * When the party is a person, the party's surname or family name. Also known as the last name.
     * Required when the party is a person. Use also to store multiple surnames including the matronymic,
     * or mother's, surname.
     */
    public function getSurname(): ?string
    {
        return $this->surname;
    }

    /**
     * Sets Surname.
     * When the party is a person, the party's surname or family name. Also known as the last name.
     * Required when the party is a person. Use also to store multiple surnames including the matronymic,
     * or mother's, surname.
     *
     * @maps surname
     */
    public function setSurname(?string $surname): void
    {
        $this->surname = $surname;
    }

    /**
     * Returns Middle Name.
     * When the party is a person, the party's middle name. Use also to store multiple middle names
     * including the patronymic, or father's, middle name.
     */
    public function getMiddleName(): ?string
    {
        return $this->middleName;
    }

    /**
     * Sets Middle Name.
     * When the party is a person, the party's middle name. Use also to store multiple middle names
     * including the patronymic, or father's, middle name.
     *
     * @maps middle_name
     */
    public function setMiddleName(?string $middleName): void
    {
        $this->middleName = $middleName;
    }

    /**
     * Returns Suffix.
     * The suffix for the party's name.
     */
    public function getSuffix(): ?string
    {
        return $this->suffix;
    }

    /**
     * Sets Suffix.
     * The suffix for the party's name.
     *
     * @maps suffix
     */
    public function setSuffix(?string $suffix): void
    {
        $this->suffix = $suffix;
    }

    /**
     * Returns Full Name.
     * When the party is a person, the party's full name.
     */
    public function getFullName(): ?string
    {
        return $this->fullName;
    }

    /**
     * Sets Full Name.
     * When the party is a person, the party's full name.
     *
     * @maps full_name
     */
    public function setFullName(?string $fullName): void
    {
        $this->fullName = $fullName;
    }

    /**
     * Converts the SubscriptionPayerName object to a human-readable string representation.
     *
     * @return string The string representation of the SubscriptionPayerName object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'SubscriptionPayerName',
            [
                'prefix' => $this->prefix,
                'givenName' => $this->givenName,
                'surname' => $this->surname,
                'middleName' => $this->middleName,
                'suffix' => $this->suffix,
                'fullName' => $this->fullName
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->prefix)) {
            $json['prefix']      = $this->prefix;
        }
        if (isset($this->givenName)) {
            $json['given_name']  = $this->givenName;
        }
        if (isset($this->surname)) {
            $json['surname']     = $this->surname;
        }
        if (isset($this->middleName)) {
            $json['middle_name'] = $this->middleName;
        }
        if (isset($this->suffix)) {
            $json['suffix']      = $this->suffix;
        }
        if (isset($this->fullName)) {
            $json['full_name']   = $this->fullName;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
