<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Information needed to pay using Trustly.
 */
class TrustlyPaymentObject implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $name;

    /**
     * @var string|null
     */
    private $countryCode;

    /**
     * @var string|null
     */
    private $email;

    /**
     * @var string|null
     */
    private $bic;

    /**
     * @var string|null
     */
    private $ibanLastChars;

    /**
     * Returns Name.
     * The full name representation like Mr J Smith.
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * Sets Name.
     * The full name representation like Mr J Smith.
     *
     * @maps name
     */
    public function setName(?string $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns Country Code.
     * The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the country
     * or region. Note: The country code for Great Britain is GB and not UK as used in the top-level domain
     * names for that country. Use the `C2` country code for China worldwide for comparable uncontrolled
     * price (CUP) method, bank card, and cross-border transactions.
     */
    public function getCountryCode(): ?string
    {
        return $this->countryCode;
    }

    /**
     * Sets Country Code.
     * The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the country
     * or region. Note: The country code for Great Britain is GB and not UK as used in the top-level domain
     * names for that country. Use the `C2` country code for China worldwide for comparable uncontrolled
     * price (CUP) method, bank card, and cross-border transactions.
     *
     * @maps country_code
     */
    public function setCountryCode(?string $countryCode): void
    {
        $this->countryCode = $countryCode;
    }

    /**
     * Returns Email.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters
     * are allowed after the @ sign. However, the generally accepted maximum length for an email address is
     * 254 characters. The pattern verifies that an unquoted @ sign exists.
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * Sets Email.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters
     * are allowed after the @ sign. However, the generally accepted maximum length for an email address is
     * 254 characters. The pattern verifies that an unquoted @ sign exists.
     *
     * @maps email
     */
    public function setEmail(?string $email): void
    {
        $this->email = $email;
    }

    /**
     * Returns Bic.
     * The business identification code (BIC). In payments systems, a BIC is used to identify a specific
     * business, most commonly a bank.
     */
    public function getBic(): ?string
    {
        return $this->bic;
    }

    /**
     * Sets Bic.
     * The business identification code (BIC). In payments systems, a BIC is used to identify a specific
     * business, most commonly a bank.
     *
     * @maps bic
     */
    public function setBic(?string $bic): void
    {
        $this->bic = $bic;
    }

    /**
     * Returns Iban Last Chars.
     * The last characters of the IBAN used to pay.
     */
    public function getIbanLastChars(): ?string
    {
        return $this->ibanLastChars;
    }

    /**
     * Sets Iban Last Chars.
     * The last characters of the IBAN used to pay.
     *
     * @maps iban_last_chars
     */
    public function setIbanLastChars(?string $ibanLastChars): void
    {
        $this->ibanLastChars = $ibanLastChars;
    }

    /**
     * Converts the TrustlyPaymentObject object to a human-readable string representation.
     *
     * @return string The string representation of the TrustlyPaymentObject object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'TrustlyPaymentObject',
            [
                'name' => $this->name,
                'countryCode' => $this->countryCode,
                'email' => $this->email,
                'bic' => $this->bic,
                'ibanLastChars' => $this->ibanLastChars
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->name)) {
            $json['name']            = $this->name;
        }
        if (isset($this->countryCode)) {
            $json['country_code']    = $this->countryCode;
        }
        if (isset($this->email)) {
            $json['email']           = $this->email;
        }
        if (isset($this->bic)) {
            $json['bic']             = $this->bic;
        }
        if (isset($this->ibanLastChars)) {
            $json['iban_last_chars'] = $this->ibanLastChars;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
